VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   3  'Fester Dialog
   Caption         =   "Form1"
   ClientHeight    =   2470
   ClientLeft      =   50
   ClientTop       =   340
   ClientWidth     =   4430
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2470
   ScaleWidth      =   4430
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton Command1 
      Caption         =   "Create PDF"
      Height          =   855
      Left            =   720
      TabIndex        =   0
      Top             =   720
      Width           =   3015
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Private WithEvents pdf As CPDF 'Activate event support
Attribute pdf.VB_VarHelpID = -1

Private Sub pdf_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = True ' We break processing if an error occurred!
End Sub

Public Function ExtractFileName(ByVal Path As String) As String
   Dim Pos As Long
   Pos = InStrRev(Path, "\")
   If Pos = 0 Then Pos = InStrRev(Path, "/")
   If Pos > 0 Then
      ExtractFileName = Mid$(Path, Pos + 1, Len(Path))
   Else
      ExtractFileName = Path
   End If
End Function

Private Sub Form_Load()
   On Error GoTo Err
   Set pdf = New CPDF
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set pdf = Nothing
End Sub

Private Sub Command1_Click()

   ' Error messages and warnings are passed to the error event function.
   Call pdf.CreateNewPDF(vbNullString) ' The ouput file is opened later

      Call pdf.SetPageCoords(TPageCoord.pcTopDown)

      Call pdf.Append
         Call pdf.SetFont("Helvetica", TFStyle.fsRegular, 14#, False, TCodepage.cp1252)
         Call pdf.WriteFTextEx(50#, 50#, pdf.GetPageWidth() - 100#, -1#, TTextAlign.taJustify, "The following pages were imported from " & _
            "different PDF files. DynaPDF adjusts the destinations of link annotations and bookmarks so that " & _
            "all destinations refer to the new page numbers after import." + Chr(13) + Chr(13) & _
            "Entire PDF files can be easily merged with ImportPDFFile() but it is also possible to import only specific pages of an arbitrary number " & _
            "of PDF files. You can also add further pages or edit imported pages if necessary. An existing page can be opened for editing with EditPage().")
      Call pdf.EndPage

      Dim i As Long
      Dim First As Boolean
      Dim DestPage As Integer
      Dim haveXFA As Boolean
      Dim isCollection As Boolean

      First = True
      DestPage = 1
      haveXFA = False
      isCollection = False

      Dim files() As String
      ReDim files(1)
      files(0) = "../../../license.pdf"
      files(1) = "../../../dynapdf_help.pdf"

      ' Generic code to merge arbitrary PDF files.
      For i = 0 To 1
         If pdf.OpenImportFile(files(i), TPwdType.ptOpen, vbNullString) < 0 Then
            Set pdf = Nothing
            Exit Sub
         End If
         ' Not all PDF files can be merged:
         '   - An Interactive Form is a global structure that cannot be simply merged. The names of all form fields must be
         '     be unique. But also if name collusions will be solved, there is no guarantee that embedded Javascripts or Javascript
         '     actions will work as expected. Interactive Forms should not be merged!

         '   - A PDF collection is a special PDF file that consists of a container PDF and an array of embedded files.
         '     It is possible to merge two or more PDF Collections but it is not meaningful to merge a PDF Collection
         '     with normal PDF files or vice versa.
         If First Then
            First = False
            haveXFA = pdf.GetInIsXFAForm()
            isCollection = pdf.GetInIsCollection()
            DestPage = pdf.ImportPDFFile(DestPage + 1, 1#, 1#)
            If DestPage < 0 Then Exit For
         Else
            ' Special handling for PDF Collections
            If isCollection Then
               If pdf.GetInIsCollection() Then
                  ' Import the embedded files only
                  Call pdf.SetImportFlags(TImportFlags.ifEmbeddedFiles)
                  ' We could also use ImportPDFFile() but this function is more efficient since no pages will be imported.
                  If Not pdf.ImportCatalogObjects() Then Exit For
               Else
                  Call pdf.CloseImportFile
                  ' Add the file to the collection
                  Call pdf.AttachFile(files(i), ExtractFileName(files(i)), True)
               End If
            Else
               If pdf.GetInIsCollection() Or pdf.GetInIsXFAForm() Or pdf.GetInFieldCount() > 0 Then
                  If pdf.GetFieldCount() > 0 Or haveXFA Then Exit For
               End If
               Call pdf.SetImportFlags(TImportFlags.ifImportAll Or TImportFlags.ifImportAsPage)  ' Import anything and avoid the conversion of pages to templates
               Call pdf.SetImportFlags2(TImportFlags2.if2UseProxy)                              ' This flag reduces the memory usage.
               DestPage = pdf.ImportPDFFile(DestPage + 1, 1#, 1#)
               If DestPage < 0 Then Exit For
            End If
         End If
         Call pdf.CloseImportFile
      Next i

   ' No fatal error occurred?
   If pdf.HaveOpenDoc Then
      ' OK, now we can open the output file.
      Dim OutFile As String
      OutFile = App.Path + "\out.pdf"
      If pdf.OpenOutputFile(OutFile) Then
         If pdf.CloseFile Then
            ShellExecuteA Me.hWnd, "open", OutFile, vbNullString, vbNullString, 1
         End If
      End If
   End If
End Sub
